/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.storage.externalstorage;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.storage.AccessType;
import com.refinedmods.refinedstorage.api.storage.externalstorage.IExternalStorage;
import com.refinedmods.refinedstorage.api.storage.externalstorage.IExternalStorageContext;
import com.refinedmods.refinedstorage.api.util.Action;
import com.refinedmods.refinedstorage.apiimpl.storage.externalstorage.FluidExternalStorageCache;
import com.refinedmods.refinedstorage.util.StackUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidExternalStorage
implements IExternalStorage<FluidStack> {
    private final IExternalStorageContext context;
    private final Supplier<IFluidHandler> handlerSupplier;
    private final boolean connectedToInterface;
    private final FluidExternalStorageCache cache = new FluidExternalStorageCache();

    public FluidExternalStorage(IExternalStorageContext context, Supplier<IFluidHandler> handlerSupplier, boolean connectedToInterface) {
        this.context = context;
        this.handlerSupplier = handlerSupplier;
        this.connectedToInterface = connectedToInterface;
    }

    public boolean isConnectedToInterface() {
        return this.connectedToInterface;
    }

    @Override
    public void update(INetwork network) {
        if (this.getAccessType() == AccessType.INSERT) {
            return;
        }
        this.cache.update(network, this.handlerSupplier.get());
    }

    @Override
    public long getCapacity() {
        IFluidHandler fluidHandler = this.handlerSupplier.get();
        if (fluidHandler != null) {
            long cap = 0L;
            for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                cap += (long)fluidHandler.getTankCapacity(i);
            }
            return cap;
        }
        return 0L;
    }

    @Override
    public Collection<FluidStack> getStacks() {
        IFluidHandler fluidHandler = this.handlerSupplier.get();
        if (fluidHandler != null) {
            ArrayList<FluidStack> fluids = new ArrayList<FluidStack>();
            for (int i = 0; i < fluidHandler.getTanks(); ++i) {
                fluids.add(fluidHandler.getFluidInTank(i));
            }
            return fluids;
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public FluidStack insert(@Nonnull FluidStack stack, int size, Action action) {
        if (stack.isEmpty()) {
            return stack;
        }
        IFluidHandler handler = this.handlerSupplier.get();
        if (this.context.acceptsFluid(stack) && handler != null) {
            int filled = handler.fill(StackUtils.copy(stack, size), action == Action.PERFORM ? IFluidHandler.FluidAction.EXECUTE : IFluidHandler.FluidAction.SIMULATE);
            if (filled == size) {
                return FluidStack.EMPTY;
            }
            return StackUtils.copy(stack, size - filled);
        }
        return StackUtils.copy(stack, size);
    }

    @Override
    @Nonnull
    public FluidStack extract(@Nonnull FluidStack stack, int size, int flags, Action action) {
        if (stack.isEmpty()) {
            return stack;
        }
        IFluidHandler handler = this.handlerSupplier.get();
        if (handler == null) {
            return FluidStack.EMPTY;
        }
        return handler.drain(StackUtils.copy(stack, size), action == Action.PERFORM ? IFluidHandler.FluidAction.EXECUTE : IFluidHandler.FluidAction.SIMULATE);
    }

    @Override
    public int getStored() {
        return this.cache.getStored();
    }

    @Override
    public int getPriority() {
        return this.context.getPriority();
    }

    @Override
    public AccessType getAccessType() {
        return this.context.getAccessType();
    }

    @Override
    public int getCacheDelta(int storedPreInsertion, int size, @Nullable FluidStack remainder) {
        if (this.getAccessType() == AccessType.INSERT) {
            return 0;
        }
        return remainder == null ? size : size - remainder.getAmount();
    }
}

